/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.snmp;

import com.ibm.hwmca.base.settings.snmp.SnmpConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class SnmpCommandLine
implements SnmpConstants {
    public static final int USAGE_ERROR = 1;
    public static final int BAD_ADDRESS_ERROR = 2;
    public static final int FILE_ERROR = 3;
    public static final int INVALID_KEY_ERROR = 4;
    public static final String TRAPS_CONFIG_FILE = "/data/snmp.trapsconfig.properties";
    public static final String TRAPS_HOSTS_FILE = "/data/snmp.traps.properties";

    private static void printUsage() {
        System.out.println("Usage: SnmpCommandLine addTrapHost <host> <keys>");
        System.out.println("Usage: SnmpCommandLine removeTrapHost <host>");
    }

    public static void main(String[] args) {
        block23: {
            String cmd;
            if (args.length < 1) {
                SnmpCommandLine.printUsage();
                System.exit(1);
            }
            if ("addTrapHost".equals(cmd = args[0])) {
                FileInputStream fis;
                Properties props;
                File file;
                if (args.length != 4) {
                    SnmpCommandLine.printUsage();
                    System.exit(1);
                }
                String hmcdir = args[1];
                String addr = args[2];
                String keyString = args[3];
                try {
                    InetAddress.getByName(addr);
                }
                catch (UnknownHostException e) {
                    System.out.println("Invalid address specified: " + addr);
                    System.exit(2);
                }
                try {
                    file = new File(hmcdir + TRAPS_CONFIG_FILE);
                    props = new Properties();
                    if (file.exists() && file.canRead()) {
                        fis = new FileInputStream(file);
                        props.load(fis);
                        fis.close();
                        boolean badKeyFound = false;
                        String[] keys = keyString.split(",");
                        for (int i = 0; i < keys.length; ++i) {
                            if (props.containsKey(keys[i])) continue;
                            System.out.println("Invalid key: " + keys[i]);
                            badKeyFound = true;
                        }
                        if (badKeyFound) {
                            System.exit(4);
                        }
                    } else {
                        System.out.println("Unable to open traps config files: " + file.getPath());
                        System.exit(3);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(3);
                }
                try {
                    file = new File(hmcdir + TRAPS_HOSTS_FILE);
                    props = new Properties();
                    if (file.exists() && file.canRead()) {
                        fis = new FileInputStream(file);
                        props.load(fis);
                        fis.close();
                    }
                    props.setProperty(addr, keyString);
                    FileOutputStream fos = new FileOutputStream(file);
                    props.store(fos, null);
                    fos.close();
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(3);
                }
            } else if ("removeTrapHost".equals(cmd)) {
                if (args.length != 3) {
                    SnmpCommandLine.printUsage();
                    System.exit(1);
                }
                String hmcdir = args[1];
                String addr = args[2];
                try {
                    InetAddress.getByName(addr);
                }
                catch (UnknownHostException e) {
                    System.out.println("Invalid address specified: " + addr);
                    System.exit(2);
                }
                try {
                    File file = new File(hmcdir + TRAPS_HOSTS_FILE);
                    Properties props = new Properties();
                    if (file.exists() && file.canRead()) {
                        FileInputStream fis = new FileInputStream(file);
                        props.load(fis);
                        fis.close();
                        props.remove(addr);
                        FileOutputStream fos = new FileOutputStream(file);
                        props.store(fos, null);
                        System.exit(0);
                        break block23;
                    }
                    System.out.println("Unable to open traps hosts files: " + file.getPath());
                    System.exit(3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(3);
                }
            } else {
                SnmpCommandLine.printUsage();
                System.exit(1);
            }
        }
    }
}

